/**
* \file: device_fsm.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_CONTROL_DEVICE_FSM_H
#define AAM_CONTROL_DEVICE_FSM_H

#include <libudev.h>

#include "model/device.h"

void device_fsm_enter_device_automounting(device_t *device,
		int expected_partition_cnt);

void device_fsm_enter_device_nomedia(device_t *device);

void device_fsm_signal_media_removed(device_t *device);

void device_fsm_signal_device_removed(device_t *device);

error_code_t device_fsm_signal_device_unmount_request(device_t *device,
        device_state_change_callback_t callback_func, void *callback_data);

void device_fsm_signal_part_handled(partition_t *partition);

#endif
